<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PlayerBankAccount extends Model 
{

    protected $table = 'player_bank_accounts';
    public $timestamps = true;
    protected $fillable = array('nickname', 'master_bank_id', 'current_bank_group_id');

    public function master_bank()
    {
        return $this->hasOne('App\Models\MasterBank', 'master_bank_id');
    }

    public function user()
    {
        return $this->hasOne('App\Models\User', 'user_id');
    }

}